import { NextRequest, NextResponse } from 'next/server';
import { featureStore, initializeDefaultData } from '@/lib/data-store';

export async function GET() {
  try {
    await initializeDefaultData();
    const features = await featureStore.getAll();
    return NextResponse.json({ success: true, data: features });
  } catch (error) {
    return NextResponse.json({ success: false, error: 'Failed to fetch features' }, { status: 500 });
  }
}

export async function POST(request: NextRequest) {
  try {
    const data = await request.json();
    const feature = await featureStore.create(data);
    return NextResponse.json({ success: true, data: feature });
  } catch (error) {
    return NextResponse.json({ success: false, error: 'Failed to create feature' }, { status: 500 });
  }
}